document.addEventListener('DOMContentLoaded', function () {
    const dateSelect = document.querySelector('[name="delivery_date"]');
    const timeSelect = document.querySelector('[name="delivery_time"]');

    function getNowMinutes() {
        const now = new Date();
        return now.getHours() * 60 + now.getMinutes();
    }

    function parseTime(text) {
        const match = text.match(/(\d{1,2}):(\d{2})/);
        return match ? parseInt(match[1]) * 60 + parseInt(match[2]) : null;
    }

    function refreshTimes() {
        const isToday = dateSelect?.value === 'today';
        const now = getNowMinutes();

        [...timeSelect.options].forEach(opt => {
            opt.disabled = false;
            opt.textContent = opt.textContent.replace(/\s*\(geçti\)/g, '');
            const t = parseTime(opt.value);
            if (isToday && t !== null && t <= now) {
                opt.disabled = true;
                opt.textContent += ' (geçti)';
            }
        });
    }

    dateSelect?.addEventListener('change', refreshTimes);
    refreshTimes();
});
