<?php

// Checkout fields
add_filter('woocommerce_checkout_fields', function ($fields) {
    $fields['order']['delivery_date'] = [
        'type'     => 'select',
        'label'    => __('Teslimat Günü', 'woocommerce'),
        'required' => true,
        'options'  => [
            ''        => 'Bir gün seçiniz',
            'today'   => 'Bugün - ' . date_i18n('l'),
            'tomorrow'=> 'Yarın - ' . date_i18n('l', strtotime('+1 day')),
        ]
    ];

    $fields['order']['delivery_time'] = [
        'type'     => 'select',
        'label'    => __('Teslimat Saat Aralığı', 'woocommerce'),
        'required' => true,
        'options'  => [
            '' => 'Bir saat seçiniz',
            '10:00 - 11:00' => '10:00 - 11:00',
            '11:00 - 12:00' => '11:00 - 12:00',
            '12:00 - 13:00' => '12:00 - 13:00',
            '13:00 - 14:00' => '13:00 - 14:00',
            '14:00 - 15:00' => '14:00 - 15:00',
            '15:00 - 16:00' => '15:00 - 16:00',
            '16:00 - 17:00' => '16:00 - 17:00',
            '17:00 - 18:00' => '17:00 - 18:00',
        ]
    ];

    return $fields;
});

// Save
add_action('woocommerce_checkout_update_order_meta', function ($order_id) {
    if (!empty($_POST['delivery_date'])) {
        update_post_meta($order_id, 'delivery_date', sanitize_text_field($_POST['delivery_date']));
    }
    if (!empty($_POST['delivery_time'])) {
        update_post_meta($order_id, 'delivery_time', sanitize_text_field($_POST['delivery_time']));
    }
});

// Display in admin
add_action('woocommerce_admin_order_data_after_billing_address', function ($order) {
    echo '<p><strong>Teslimat Günü:</strong> ' . get_post_meta($order->get_id(), 'delivery_date', true) . '</p>';
    echo '<p><strong>Teslimat Saati:</strong> ' . get_post_meta($order->get_id(), 'delivery_time', true) . '</p>';
});
