<?php
/**
 * Enqueue script and styles for child theme
 */
function woodmart_child_enqueue_styles() {
	wp_enqueue_style( 'child-style', get_stylesheet_directory_uri() . '/style.css', array( 'woodmart-style' ), woodmart_get_theme_info( 'Version' ) );
}
add_action( 'wp_enqueue_scripts', 'woodmart_child_enqueue_styles', 10010 );

// WooCommerce'a özel "Yola Çıktı" sipariş durumu ekle ve özel e-posta bildirimi gönder

// 1. Yeni sipariş durumunu kaydet
add_action('init', function () {
    register_post_status('wc-yola-cikti', array(
        'label'                     => 'Yola Çıktı',
        'public'                    => true,
        'exclude_from_search'       => false,
        'show_in_admin_all_list'    => true,
        'show_in_admin_status_list' => true,
        'label_count'               => _n_noop('Yola Çıktı <span class="count">(%s)</span>', 'Yola Çıktı <span class="count">(%s)</span>')
    ));
});

// 2. Sipariş durumları listesine "Yola Çıktı"yı ekle
add_filter('wc_order_statuses', function ($order_statuses) {
    $new_order_statuses = [];
    foreach ($order_statuses as $key => $status) {
        $new_order_statuses[$key] = $status;
        if ('wc-processing' === $key) {
            $new_order_statuses['wc-yola-cikti'] = 'Yola Çıktı';
        }
    }
    return $new_order_statuses;
});

// 3. Yola Çıktı durumunda özel e-posta bildirimi tetikle
add_action('woocommerce_order_status_yola-cikti', function ($order_id) {
    $order = wc_get_order($order_id);

    // 3.1 Özel e-posta başlığı ve içeriği burada tanımlanır
    $mailer = WC()->mailer();
    $recipient = $order->get_billing_email();
    $subject = 'Siparişiniz yola çıktı!'; // <-- Buraya istediğin başlığı yaz
    $message = '
        <p>Merhaba ' . esc_html($order->get_billing_first_name()) . ',</p>
        <p>Siparişiniz paketlendi ve kuryemiz yola çıktı 🚚</p>
        <p>En kısa sürede kapınızda olacak. İyi günlerde kullanmanız dileğiyle!</p>
        <p><strong>Sipariş Numarası:</strong> #' . $order->get_order_number() . '</p>
        <p>Teşekkür ederiz,<br> ' . get_bloginfo('name') . ' Ekibi</p>
    '; // <-- Buraya istediğin e-posta içeriğini yaz

    // 3.2 E-posta gönderimi
    $headers = array('Content-Type: text/html; charset=UTF-8');
    wp_mail($recipient, $subject, $message, $headers);
});

// 1. "Hesabımı Sil" sekmesini "Hesabım" menüsüne ekle
add_filter('woocommerce_account_menu_items', 'add_delete_account_link', 999);
function add_delete_account_link($items) {
    $items['delete-account'] = 'Hesabımı Sil';
    return $items;
}

// 2. "delete-account" endpoint'ini tanımla
add_action('init', 'register_delete_account_endpoint');
function register_delete_account_endpoint() {
    add_rewrite_endpoint('delete-account', EP_ROOT | EP_PAGES);
}

// 3. "Hesabımı Sil" sayfa içeriği – Buton ve işlem
add_action('woocommerce_account_delete-account_endpoint', 'delete_account_content');
function delete_account_content() {
    if (!is_user_logged_in()) {
        echo '<p>Bu işlemi gerçekleştirmek için giriş yapmalısınız.</p>';
        return;
    }

    // Silme işlemi tetiklendiğinde
    if (isset($_POST['delete_account']) && check_admin_referer('delete_account_action', 'delete_account_nonce')) {
        $user_id = get_current_user_id();
        require_once(ABSPATH.'wp-admin/includes/user.php');
        wp_delete_user($user_id);
        wp_redirect(home_url()); // Silme sonrası anasayfaya yönlendir
        exit;
    }

    // Butonu göster
    ?>
    <h2>Hesabınızı Kalıcı Olarak Silin</h2>
    <p>Bu işlemi geri alamazsınız. Emin misiniz?</p>
    <form method="post">
        <?php wp_nonce_field('delete_account_action', 'delete_account_nonce'); ?>
        <input type="submit" name="delete_account" value="Hesabımı Kalıcı Olarak Sil" 
               onclick="return confirm('Bu işlem geri alınamaz. Hesabınızı silmek istediğinize emin misiniz?');"
               style="padding:10px 20px; background:#c00; color:#fff; border:none; cursor:pointer;">
    </form>
    <?php
}

// 4. WordPress'e yeni endpointi tanıttıktan sonra permalink ayarlarını yenile
// Admin panelden Ayarlar > Kalıcı Bağlantılar > "Değişiklikleri Kaydet" demeyi unutma





 
// 📌 1. Checkout alanlarını sabitle (disabled + default değerler)
add_filter('woocommerce_checkout_fields', function($fields) {

    // Fatura adresi
    $fields['billing']['billing_country']['type'] = 'hidden';
    $fields['billing']['billing_country']['default'] = 'TR';
    $fields['billing']['billing_country']['label'] = false;

    $fields['billing']['billing_state'] = [
        'type' => 'select',
        'label' => 'İl',
        'options' => ['TR23' => 'Elazığ'],
        'default' => 'TR23',
        'required' => true,
        'custom_attributes' => ['disabled' => 'disabled']
    ];

    $fields['billing']['billing_city'] = [
        'type' => 'select',
        'label' => 'İlçe',
        'options' => ['Merkez' => 'Merkez'],
        'default' => 'Merkez',
        'required' => true,
        'custom_attributes' => ['disabled' => 'disabled']
    ];

    // Gönderim adresi
    $fields['shipping']['shipping_country']['type'] = 'hidden';
    $fields['shipping']['shipping_country']['default'] = 'TR';
    $fields['shipping']['shipping_country']['label'] = false;

    $fields['shipping']['shipping_state'] = [
        'type' => 'select',
        'label' => 'İl',
        'options' => ['TR23' => 'Elazığ'],
        'default' => 'TR23',
        'required' => true,
        'custom_attributes' => ['disabled' => 'disabled']
    ];

    $fields['shipping']['shipping_city'] = [
        'type' => 'select',
        'label' => 'İlçe',
        'options' => ['Merkez' => 'Merkez'],
        'default' => 'Merkez',
        'required' => true,
        'custom_attributes' => ['disabled' => 'disabled']
    ];

    return $fields;
});


// 📌 2. POST verisine "disabled" alanlar dahil edilmeyeceği için elle ekle
add_filter('woocommerce_checkout_posted_data', function($data) {
    $data['billing_country'] = 'TR';
    $data['billing_state'] = 'TR23';
    $data['billing_city'] = 'Merkez';

    $data['shipping_country'] = 'TR';
    $data['shipping_state'] = 'TR23';
    $data['shipping_city'] = 'Merkez';

    return $data;
});


// 📌 3. Checkout açıldığında müşteri nesnesine gönderim adresi zorla set et
add_action('woocommerce_before_checkout_form', function() {
    if (!is_admin() && !WC()->cart->is_empty()) {
        WC()->customer->set_shipping_country('TR');
        WC()->customer->set_shipping_state('TR23');
        WC()->customer->set_shipping_city('Merkez');
    }
});


// 📌 4. Kargo paketleme sırasında gönderim bölgesi eşleşmesini zorla tanımla
add_filter('woocommerce_cart_shipping_packages', function($packages) {
    foreach ($packages as &$package) {
        $package['destination']['country'] = 'TR';
        $package['destination']['state'] = 'TR23';
        $package['destination']['city'] = 'Merkez';
    }
    return $packages;
});


// 📌 5. Admin panelde veya kullanıcı hesabında TR23 yerine "Elazığ" göster
add_filter('woocommerce_customer_get_billing_state', function($state) {
    return $state === 'TR23' ? 'Elazığ' : $state;
}, 10, 2);
add_filter('woocommerce_customer_get_shipping_state', function($state) {
    return $state === 'TR23' ? 'Elazığ' : $state;
}, 10, 2);


// 📌 6. Checkout sayfasında devre dışı (disabled) alanları gri göster
add_action('wp_head', function() {
    if (is_checkout()) {
        echo '<style>
            select[disabled], input[disabled] {
                background-color: #e9ecef !important;
                color: #6c757d !important;
                cursor: not-allowed !important;
            }
        </style>';
    }
});


/* =========================================================================
 * BİTTİ ✅ - WooCommerce Elazığ sabit adres yapılandırması tamamlandı.
 * ========================================================================= */

// Sipariş Detaylarına Müşterinin Kayıt Tarihini Göster //
add_action('woocommerce_admin_order_data_after_order_details', 'add_customer_registered_date_to_order_panel');

function add_customer_registered_date_to_order_panel($order) {
    $user_id = $order->get_user_id();

    if (!$user_id) {
        return; // Misafir siparişi
    }

    $user_info = get_userdata($user_id);
    $registered = date_i18n('d F Y, H:i', strtotime($user_info->user_registered));

    echo '<div class="order_data_column">';
    echo '<h4>Kayıt Tarihi</h4>';
    echo '<p>' . esc_html($registered) . '</p>';
    echo '</div>';
}

// ViewContent Piksel Olayını Tetikle //
add_action('wp_footer', 'custom_viewcontent_pixel');
function custom_viewcontent_pixel() {
    if (is_product()) {
        global $product;
        ?>
        <script>
            fbq('track', 'ViewContent', {
                content_ids: ['<?php echo $product->get_id(); ?>'],
                content_type: 'product',
                value: <?php echo $product->get_price(); ?>,
                currency: 'TRY'
            });
        </script>
        <?php
    }
}

// Form Başlığını Değiştirir//
add_filter( 'gettext', function( $translated_text, $text, $domain ) {
    if ( $translated_text === 'Faturalama ve Gönderim' && $domain === 'woocommerce' ) {
        $translated_text = 'Teslimat Bilgileri';
    }
    return $translated_text;
}, 10, 3 );



